import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Define colors for statuses
clear_color = 'green'
not_clear_color = 'red'
hand_empty_color = 'blue'

# Draw the table
table = patches.Rectangle((0, 0), 10, 1, linewidth=1, edgecolor='black', facecolor='lightgrey')
ax.add_patch(table)
ax.text(5, 0.5, 'Table', ha='center', va='center', fontsize=10, color='black')

# Draw blocks
blocks = {
    'a': {'pos': (1, 1), 'supports': 'd', 'color': not_clear_color},
    'b': {'pos': (4, 1), 'supports': 'c', 'color': not_clear_color},
    'c': {'pos': (4, 2), 'supports': None, 'color': clear_color},
    'd': {'pos': (1, 2), 'supports': None, 'color': clear_color},
    'e': {'pos': (7, 1), 'supports': None, 'color': clear_color},
}

for block, info in blocks.items():
    rect = patches.Rectangle(info['pos'], 2, 1, linewidth=1, edgecolor='black', facecolor=info['color'])
    ax.add_patch(rect)
    ax.text(info['pos'][0] + 1, info['pos'][1] + 0.5, f'Block {block.upper()}\n{("Clear" if info["color"] == clear_color else "Occupied")}',
            ha='center', va='center', fontsize=8, color='white')

# Draw the hand
hand = patches.Ellipse((5, 4), 1, 0.5, linewidth=1, edgecolor='black', facecolor=hand_empty_color)
ax.add_patch(hand)
ax.text(5, 4, 'Hand\nEmpty', ha='center', va='center', fontsize=8, color='white')

# Add a legend
legend_patches = [
    patches.Patch(color=clear_color, label='Clear'),
    patches.Patch(color=not_clear_color, label='Occupied'),
    patches.Patch(color=hand_empty_color, label='Hand Empty')
]
ax.legend(handles=legend_patches, loc='upper right', fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 10)
ax.set_ylim(0, 5)
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_21.png', bbox_inches='tight')
plt.show()